% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSproc.R
\name{GSproc}
\alias{GSproc}
\title{Gram-Schmidt procedure}
\usage{
GSproc(polyK, ivec, weight = NULL)
}
\arguments{
\item{polyK}{One list including \code{$Y} and \code{$phy} with:
\code{$Y} a matrix for which the ith column will be used
to add one orthogonal vector to the (i-1)th vectors of the
current orthogonal base;
and \code{$phy} such as the current orthogonal base is
given by the (i-1)th first columns of matrix \code{polyK$phy}.}

\item{ivec}{Defines i, the current vector of \code{polyK$Y} and
the current orthogonal base of \code{pParam$phy}.}

\item{weight}{The weighing vector.}
}
\value{
\code{uNew} The model parameterization, that is:
The residual orthogonal vector that can be included into
the current orthogonal base. If the current base is empty,
\code{uNew} is equal to the input vector of \code{$Y};
if the base is complete, \code{uNew} equals 0.
}
\description{
Computes regressors coefficients
using the Gram-Schmidt procedure.
}
\author{
Sylvain Mangiarotti
}
