% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivODE2.R
\name{derivODE2}
\alias{derivODE2}
\title{A subfonction for the numerical integration
of polynomial equations provided in a generic form
following the convetion defined by function \code{poLabs}.}
\usage{
derivODE2(t, x, K, dMin = 0, regS = NULL)
}
\arguments{
\item{t}{All the dates for which the result of the numerical
integration of the model must be provided}

\item{x}{Current state vector (input from which the next state will
be estimated)}

\item{K}{A matrix providing the model description:
each column corresponds to one equation which polynomial organisation
is following the convention defined by function \code{poLabs}.}

\item{dMin}{The minimum negative degree of the polynomial
formulation (0 by default).}

\item{regS}{Current states of each polynomial terms used
in \code{poLabs}. These states can be deduced from the current
state vector \code{x} (using the function \code{regSeries}).
When available, it can be provided as an input to avoid
unecessary computation.}
}
\description{
This function provides the one step integration of
polynomial Ordinary Differential Equations (ODE). This function
requires the function \code{ode} (\code{deSolve} package).
}
\seealso{
\code{\link{numicano}}, \code{\link{numinoisy}}
}
\author{
Sylvain Mangiarotti
}
