% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSparO.R
\name{GSparO}
\alias{GSparO}
\title{Group sparse optimization}
\usage{
GSparO(A, b, Initial, group, MaxIter, sparsity)
}
\arguments{
\item{A}{decoding matrix (matrix of predictors)}

\item{b}{noised signal (response)}

\item{Initial}{an initial point of iteration, recommend to set as a column vector of zeros}

\item{group}{group information, a column vector consisting of the length of each group}

\item{MaxIter}{the maximum number of iterations (a stopping criterion), recommend to set as 200}

\item{sparsity}{a guess of the group sparsity level (the number of nonzero groups)}
}
\description{
Group sparse optimization (GSparO) for least squares regression by using the proximal gradient algorithm to solve the L_{2,1/2} regularization model.
}
\details{
GSparO is group sparse optimization for least squares regression described in [Hu et al(2017)], in which the proximal gradient algorithm is implemented to solve the L_{2,1/2} regularization model. GSparO is an iterative algorithm consisting of a gradient step for the least squares regression and a proximal steps for the L_{2,1/2} penalty, which is analytically formulated in this function. Also, GSparO can solve sparse variable selection problem in absence of group structure. In particular, setting group in GSparO be a vector of ones, GSparO is reduced to the iterative half thresholding algorithm introduced in [Xu et al (2012)].
Copyright by Dr. Yaohua Hu, College of Mathematics and Statistics, Shenzhen University.
Email: mayhhu@szu.edu.cn
}
\author{Yaohua Hu}
\references{Y. Hu, C. Li, K. Meng, J. Qin, and X. Yang (2017). Group sparse optimization via L_{p,q} regularization. Journal of Machine Learning Research, to appear.

Z. Xu, X. Chang, F. Xu, and H. Zhang (2012). L_1/2 regularization: A thresholding representation theory and a fast solver. IEEE Transactions on Neural Networks and Learning Systems.
}
\examples{
m <- 256
n <- 1024
sparsity <- 6
gLen <- 16
MaxIter <- 200
gNo <- 1024/gLen
group <- gLen*matrix(1,gNo,1)
A <- matrix(rnorm(m*n,0,1),m,n)
library(ThreeWay)
A <- orth(t(A))
A <- t(A)
gNo1 <- 1:gNo
ActInd <- sample(gNo1,gNo)
Bs <- matrix(0,n,1)
c <- matrix(rnorm(n,0,1),n,1)
for (i in 1:sparsity){
 Bs[((ActInd[i]-1)*gLen+1):(ActInd[i]*gLen)] <- matrix(1,gLen,1)}
c <- Bs*c
sigma <- 1e-3
b <- A\%*\%c + sigma*matrix(runif(m,min=0,max=1),m,1)
Initial <- matrix(0,n,1)
GSparO(A,b,Initial,group,MaxIter,sparsity)
}
