% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_manipulation.R
\name{convert_units}
\alias{convert_units}
\title{Convert Units in GTAP Data}
\usage{
convert_units(
  data,
  change_unit_from = NULL,
  change_unit_to = NULL,
  adjustment = NULL,
  value_col = "Value",
  unit_col = "Unit",
  variable_select = NULL,
  variable_col = "Variable",
  scale_auto = NULL
)
}
\arguments{
\item{data}{A data structure (list, data frame, or nested combination).}

\item{change_unit_from}{Character vector. Units to be converted (case-insensitive).}

\item{change_unit_to}{Character vector. Target units corresponding to \code{change_unit_from}.}

\item{adjustment}{Character or numeric vector. Specifies conversion operations (e.g., \code{"/1000"} to convert million to billion).}

\item{value_col}{Character. Column name containing values to adjust (default: \code{"Value"}).}

\item{unit_col}{Character. Column name containing unit information (default: \code{"Unit"}).}

\item{variable_select}{Optional character vector. If provided, only these variables are converted.}

\item{variable_col}{Character. Column name containing variable identifiers (default: \code{"Variable"}).}

\item{scale_auto}{Optional character vector of predefined conversion rules:
\itemize{
\item \code{"mil2bil"}: Converts million USD to billion USD (divides by 1000).
\item \code{"bil2mil"}: Converts billion USD to million USD (multiplies by 1000).
\item \code{"pct2frac"}: Converts percent to fraction (divides by 100).
\item \code{"frac2pct"}: Converts fraction to percent (multiplies by 100).
}}
}
\value{
A data structure with values converted to the specified units.
}
\description{
Converts values in a dataset to different units based on predefined transformations or custom scaling.
Supports manual and automatic conversions for economic and trade-related metrics.
}
\details{
If both \code{change_unit_from} and \code{scale_auto} are provided, the function prompts the user
to choose between manual and automatic conversion.
}
\examples{
# Load Data:
input_path <- system.file("extdata/in", package = "GTAPViz")
sl4.plot.data <- readRDS(file.path(input_path, "sl4.plot.data.rds"))

# Convert million USD to billion USD
gtap_data <- convert_units(sl4.plot.data,
  change_unit_from = "million USD",
  change_unit_to = "billion USD",
  adjustment = "/1000"
)

# Automatic conversion from percent to fraction
gtap_data <- convert_units(sl4.plot.data, scale_auto = "pct2frac")

}
\seealso{
\code{\link{add_mapping_info}}, \code{\link{rename_value}}, \code{\link{sort_plot_data}}
}
\author{
Pattawee Puangchit
}
