#' Degree Calculation for Random Interval Graph
#'
#' Computes the degree of each vertex in a Random Interval Graph based on the input intervals.
#'
#' @param x A numeric vector of length m=2*nv.
#' @return A vector of degrees for each vertex of RIG obtained using x.
#' @examples
#' x <- arima.sim(model = list(ar=0.7), 1000) ## AR(1) model
#' deg.rig(x)
#' @export
deg.rig <- function(x) {
  nv <- length(x) %/%2
  s <- c()
  e <- c()
  for (k in 1:nv) {
    s[k] <- x[2*k - 1]
    e[k] <- x[2*k]
  }
  start <- pmin(s, e)
  end <- pmax(s, e)
  order_idx <- order(start)
  start <- start[order_idx]
  end <- end[order_idx]
  deg <- integer(nv)
  for (i in 1:(nv - 1)) {
    for (j in (i + 1):nv) {
      if (start[j] > end[i]) break
      if (start[i] <= end[j] && start[j] <= end[i]) {
        deg[i] <- deg[i] + 1
        deg[j] <- deg[j] + 1
      }
    }
  }
  deg_final <- integer(nv)
  deg_final[order_idx] <- deg
  return(deg_final)
}
