% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcagep.test.R
\name{rcagep.test}
\alias{rcagep.test}
\title{RCAG-EP Test}
\usage{
rcagep.test(theta, alpha)
}
\arguments{
\item{theta}{A numeric vector.}

\item{alpha}{The level of significance}
}
\value{
Probability of non-intersection of edges, cutoff for RCAG-EP test and adjusted p-values for the RCAG-EP test.
}
\description{
Performs the RCAG-EP test of randomness for circular data.
}
\examples{
x <- arima.sim(model = list(ar=0.9), 1000) ## AR(1) model
theta <- ((2*atan(x))\%\%(2*pi))*(180/pi) ##LAR(1) model
rcagep.test(theta,0.05)
}
