% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FG.R
\name{dFG}
\alias{dFG}
\alias{rFG}
\title{The Flexible Gumbel Distribution}
\usage{
dFG(x, w, loc, sigma1, sigma2)

rFG(n, w, loc, sigma1, sigma2)
}
\arguments{
\item{x}{vector of quantiles.}

\item{w}{vector of weight parameters.}

\item{loc}{vector of the location parameters.}

\item{sigma1}{vector of the scale parameters of the left skewed part.}

\item{sigma2}{vector of the scale parameters of the right skewed part.}

\item{n}{number of observations.}
}
\value{
\code{dFG} gives the density. \code{rFG} generates random deviates.
}
\description{
The Flexible Gumbel Distribution
}
\details{
The Gumbel distribution has the density
\deqn{f_{\text {Gumbel }}(y \mid \theta, \sigma)=\frac{1}{\sigma} \exp \left\{-\frac{y-\theta}{\sigma}-\exp \left(-\frac{y-\theta}{\sigma}\right)\right\},}
where \eqn{\theta \in \mathbb{R}} is the mode as the location parameter, \eqn{\sigma > 0} is the scale parameter.

The flexible Gumbel distribution has the density
\deqn{f_{\mathrm{FG}}\left(y \mid w, \theta, \sigma_1, \sigma_2\right)=w f_{\text {Gumbel }}\left(-y \mid-\theta, \sigma_1\right)+(1-w) f_{\text {Gumbel }}\left(y \mid \theta, \sigma_2\right) .}
where \eqn{w \in [0,1]} is the weight parameter, \eqn{\sigma_{1} > 0} is the scale parameter of the left skewed part and \eqn{\sigma_{2} > 0} is the scale parameter of the right skewed part.
}
\examples{
set.seed(100)
require(graphics)

# Random Number Generation
X <- rFG(n = 1e5, w = 0.3, loc = 0, sigma1 = 1, sigma2 = 2)

# Plot the histogram
hist(X, breaks = 100, freq = FALSE)

# The red dashed line should match the underlining histogram
points(x = seq(-10,20,length.out = 1000),
       y = dFG(x = seq(-10,20,length.out = 1000),
               w = 0.3, loc = 0, sigma1 = 1, sigma2 = 2),
       type = "l",
       col = "red",
       lwd = 3,
       lty = 2)
}
\references{
\insertRef{liu2022bayesian}{GUD}
}
