% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotConvexHull.R
\name{PlotConvexHull}
\alias{PlotConvexHull}
\title{Plots the minimum convex hull of a set of coordinates}
\usage{
PlotConvexHull(xcoord, ycoord, lcolor = "blue")
}
\arguments{
\item{xcoord}{- Array of x-coordinates or longitudinal values}

\item{ycoord}{- Array of y-coordinates or latitudinal values}

\item{lcolor}{- String or integer value indicating the color of the convex hull boundary lines}
}
\value{
Plots a minimum convex hull
}
\description{
Plots the minimum convex hull of a set of coordinates
}
\note{
This function does not account for the possibility of points crossing the prime meridian and in cases where this occurs the convex hull shown will be incorrect
}
\examples{
longs<-c(20,20,40,40)
lats<-c(-5,5,-5,5)
PlotConvexHull(xcoord=longs,ycoord=lats)
}
