% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shock_cal.R
\name{create_initial_config}
\alias{create_initial_config}
\title{Create Initial Value Configuration}
\usage{
create_initial_config(path, format, header, value_col = "Value")
}
\arguments{
\item{path}{Path to the initial data file.}

\item{format}{File format of the initial dataset. Must be "har" or "sl4".}

\item{header}{Header name within the HAR or SL4 file to extract.}

\item{value_col}{Name of the column containing numeric values. Default is "Value".}
}
\value{
A list containing:
\itemize{
\item \code{path}: input file path
\item \code{format}: file format ("har" or "sl4")
\item \code{header}: target header name
\item \code{value_col}: column name for numeric values
}
}
\description{
Defines the configuration for loading the initial dataset, including path, format,
variable header, and value column name. Used as input for \code{\link{shock_calculate}}
and \code{\link{shock_calculate_uniform}}.
}
\details{
\itemize{
\item Supports \code{HAR} and \code{SL4} file formats
\item Specifies the header name to extract from the dataset
\item Allows custom naming for the value column (\code{Value} by default)
}
}
\examples{
# Example: Define Initial Configuration
initial <- create_initial_config(
  path   = "D:/Data/taxrates_2017.har",
  format = "har",
  header = "rTMS"
)
}
\seealso{
\code{\link{create_target_config}}, \code{\link{create_calc_config}},
\code{\link{shock_calculate}}, \code{\link{shock_calculate_uniform}}
}
\author{
Pattawee Puangchit
}
