% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_indices.R
\name{select_indices}
\alias{select_indices}
\title{Allows for selecting some peptide from input data}
\usage{
select_indices(df, start = NA, end = NA, length = NA, times = NA, states = NA)
}
\arguments{
\item{df}{input file (output of output_tc or output_tp)}

\item{start}{provide number for the staring residue, default NA}

\item{end}{provide number for the end residue, default NA}

\item{length}{provide max length of the peptide}

\item{times}{timepoints, only for the output_tp functions}

\item{states}{states, only for the output_tc functions}
}
\value{
Row indices of the peptides that are fulfilling the conditions required.
}
\description{
Function allows for picking indices from the inputs based on:
peptide start or end residue, length, state or timepoint.
If parameters set to NA, condition is skipped.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tp(file_nm)
indb<-select_indices(a,length=12, start=100, end=200)
smaller_df<-a[indb,]
}
