% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HTSeed.R
\name{seed.extreme}
\alias{seed.extreme}
\title{Title Extreme value distribution of base seed water potential}
\usage{
seed.extreme(psi, time, c.germinated, N, d=NULL, theta)
}
\arguments{
\item{psi}{Soil water potential}

\item{time}{Time taken to germinate}

\item{c.germinated}{Cumulative number of seeds germinated}

\item{N}{Total number of seeds under each soil water potential}

\item{d}{Proportion of viability}

\item{theta}{Hydrotime constant}
}
\value{
\itemize{
  \item parameters: mu (stress tolerance parameter)and sigma (uniformity of germination parameter)
  \item Result_fitting: Actual cumulative seed germination fraction (Actual_CGfraction) and Fitted cumulative seed germination fraction (Fitted_CGfraction)
}
}
\description{
The distribution of base seed water potential is following the extreme value distribution. Here, the stress tolerance parameter is characterised by 63 percentile in the distribution of base seed water potential.
}
\examples{
psi<-c(rep(0, 19), rep(-0.2, 6), rep(-0.4, 10))
time<- c(1.5, 2, 2.5, 3, 3.5, 4, 4.5, 5, 6, 7, 9, 10, 12, 16, 18, 20, 23, 26,
30, 4.5, 5, 6, 20, 23, 30, 3, 3.5, 4, 4.5, 5, 6, 7, 9, 12, 16)
c.germinated<- c(1, 2, 6, 11, 20, 24, 30, 34, 39, 41, 43, 47, 56, 58, 59, 63,
67, 72, 73, 29, 31, 35, 63, 64, 65, 11, 13, 18, 21, 22, 25, 26, 28, 29, 30)
d<- c(0.8, 0.8, 0.6)
my.extreme<-seed.extreme(psi= psi, time= time, c.germinated= c.germinated, N=100, d=d, theta= 90)
}
\references{
\itemize{
\item Bradford, K. J. (2002). Applications of Hydrothermal Time to Quantifying and Modeling Seed Germination and Dormancy. Weed Science, 50(2), 248–260. http://www.jstor.org/stable/4046371.
\item Bradford, K. J., & Still, D. W. (2004). Applications of Hydrotime Analysis in Seed Testing. Seed Technology, 26(1), 75–85. http://www.jstor.org/stable/23433495
}
}
