% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_engelund1967.R
\name{n_engelund1967}
\alias{n_engelund1967}
\title{Compute form roughness following Engelund and Hansen (1967)}
\usage{
n_engelund1967(depth, slope, d50, restrict = TRUE)
}
\arguments{
\item{depth}{flow depth (H) in meters}

\item{slope}{channel slope (S) in m/m}

\item{d50}{grain size (d50) in millimeters}

\item{restrict}{allows for function parameters to restrict certain values. Type bool. Default TRUE.}
}
\value{
Manning's n
}
\description{
\code{n_engelund1967} calculate Manning's n using the Engelund-Hansen (1981)
method for estimating form roughness
}
\examples{
# Result: Manning's n of 0.049
n_engelund1967(1, 0.025, 200)

# Result: Manning's n of 0.028
n_engelund1967(5, 0.08, 90)

# Result: Manning's n of 0.053
n_engelund1967(12, 0.025, 160)

}
\references{
Engelund, F., and E. Hansen. 1967. A Monograph on Sediment Transport in Alluvial Streams.
Technical University of Denmark, Copenhagen, Denmark.
}
