% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdn_baumert.R
\name{cdn_baumert}
\alias{cdn_baumert}
\title{cdn_baumert}
\usage{
cdn_baumert(order)
}
\arguments{
\item{order}{integer, order of Hadamard matrix to be checked.}
}
\value{
6 or NULL
}
\description{
Checks Hadamard Matrix can be constructed using Baumert-Hall arrays of order 12.
}
\details{
Baumert-Hall array is a generalization of Williamson Array.
In case, Williamson matrices are available for order/12, the method
return 6 otherwise it returns NULL.

The availabile Williamson sequences in the internal data sets is
seq(1,63, 2) except 15, 35, 47, 53, 59 in the internal table.
}
\examples{
cdn_baumert(36)
#6
cdn_baumert(72)
#NULL
}
\references{
Hedayat, A. and Wallis, W. D.(1978).  Hadamard Matrices and Their Applications. Ann. Stat. 6: 1184-1238.
}
\seealso{
\code{\link{had_baumert}} for Baumert-Hall's construction method.
}
