% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdn_goethals_Turyn.R
\name{cdn_goethals_Turyn}
\alias{cdn_goethals_Turyn}
\title{cdn_goethals_Turyn}
\usage{
cdn_goethals_Turyn(order)
}
\arguments{
\item{order}{integer}
}
\value{
8 or NULL
}
\description{
Checks Hadamard Matrix can be constructed using available Turyn Type sequences.
}
\details{
This function checks whether the Hadamard matrix of given order can be constructed using Turyn sequences.
If Turyn sequences of (order+4)/12 is available then Hadamard matrix of order exists.
Returns the value 8, if it is possible otherwise NULL is returned.

Turyn type-sequences are available for 28,30,34,36 in the internal table.
}
\examples{
cdn_goethals_Turyn(356)
#8
cdn_goethals_Turyn(40)
#NULL
}
\seealso{
\code{\link{had_goethals_Turyn}} for Goethals-Seidel construction method using Turyn sequences.
}
