% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/framework.R
\name{hapiFilterError}
\alias{hapiFilterError}
\title{Filter out hetSNPs with potential genotyping errors}
\usage{
hapiFilterError(gmt, hmm = NULL)
}
\arguments{
\item{gmt}{a dataframe of genotype data of gamete cells}

\item{hmm}{a list containing probabilities of a HMM. Default is \code{NULL}}
}
\value{
a dataframe of genotype data of gamete cells
}
\description{
Filter out hetSNPs with potential genotyping errors
}
\examples{
ref <- rep(0,500)
alt <- rep(1,500)

gmt <- data.frame(gmt1=ref, gmt2=alt, gmt3=ref,
    gmt4=ref, gmt5=c(alt[1:250], ref[251:500]),
    stringsAsFactors = FALSE)
    
idx <- sort(sample(seq_len(500), 10, replace = FALSE))
gmt[idx,1] <- 1

gmtDa <- hapiFilterError(gmt = gmt)
}
\author{
Ruidong Li
}
