% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_beta_coeff_functions.R
\name{data_beta_coeff_glm}
\alias{data_beta_coeff_glm}
\title{Obtain GLM Beta Coefficients for tabular data}
\usage{
data_beta_coeff_glm(data, iblm_model)
}
\arguments{
\item{data}{Data frame with predictor variables}

\item{iblm_model}{Object of class 'iblm'}
}
\value{
A data frame with beta coefficients. The structure will be the same dimension as `data` except for a "bias" column at the start.
}
\description{
Creates dataframe of GLM beta coefficients for each row and predictor variable of `data`
}
\examples{
df_list <- freMTPLmini |> split_into_train_validate_test(seed = 9000)

iblm_model <- train_iblm_xgb(
  df_list,
  response_var = "ClaimRate",
  family = "poisson"
)

data_glm <- data_beta_coeff_glm(df_list$train, iblm_model)

data_glm |> dplyr::glimpse()

}
