% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICED_syntax.R
\name{iced_syntax}
\alias{iced_syntax}
\title{iced_syntax function - generates lavaan syntax for ICED models}
\usage{
iced_syntax(
  structure,
  fix_lower_bounds = TRUE,
  set_variances = NULL,
  e_label = "e",
  print = TRUE,
  groups = NULL,
  groups_inequality = NULL
)
}
\arguments{
\item{structure}{data.frame describing the structure of the data, with each variable covering a design aspect - see example. Note: currently the first variable must be time and include a different value for each repeated measure.}

\item{fix_lower_bounds}{fixes error variance estimates to be positive, defaults to TRUE}

\item{set_variances}{allows the user to specify a list of variances for each latent variable}

\item{e_label}{user defined variable name of the error variance. defaults to "e"}

\item{print}{option to print the syntax to the console. defaults to TRUE}

\item{groups}{allows the user to specify a number or list of group names. The syntax will generate separate latent variable variances to estimate for each group}

\item{groups_inequality}{allows the user to specify which variance components they wish to allow to vary between groups. Useful for model comparisons.}
}
\value{
returns a character string for the ICED model following lavaan syntax
}
\description{
The function takes a dataframe describing the data structure and returns lavaan syntax to run the model
}
\examples{
## see online documentation for full examples
# https://github.com/sdparsons/ICED
structure <- data.frame(time = c("T1", "T2", "T3", "T4"),
                        day = c("day1","day1","day2","day2"),
                        session = c("session1", "session1","session2", "session3"))


}
