% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICED_run.R
\name{run_ICED}
\alias{run_ICED}
\title{run ICED models}
\usage{
run_ICED(model = NULL, data = NULL, boot = NULL, ncores = NULL)
}
\arguments{
\item{model}{lavaan model syntax, generated with ICED_syntax}

\item{data}{specify data to be analysed - repeated measures variable names must correspond to separate variables in the data (wide format)}

\item{boot}{run bootstrapped analysis to extract 95\% CIs for the ICC and ICC2 estimates}

\item{ncores}{specify the number of cores to run with boot, defaults to 1}
}
\value{
returns a list of estimated variances and reliability coefficients and the lavaan output
}
\description{
Wrapper function for lavaan to run an ICED model generated with ICED_syntax()
}
\examples{
## see online documentation for full examples
# https://github.com/sdparsons/ICED

# generate data structure and syntax
struc <- data.frame(time = c("T1", "T2", "T3", "T4"),
day = c("day1","day1","day2","day2"),
session = c("ses1", "ses1","ses2", "ses3"))

syn <- iced_syntax(struc)

# generate data
sim1 <- sim_ICED(struc,
variances = list(time = 10,
               day = 2,
                 session = 1,
                 error = 3),
n = 2000)

res1 <- run_ICED(model = syn,
data = sim1$data)


}
