% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.elm_forecast.R
\name{pca.elm_forecast}
\alias{pca.elm_forecast}
\title{Forecasting from PCA based ELM model}
\usage{
pca.elm_forecast(pca.elm_model, h = 1)
}
\arguments{
\item{pca.elm_model}{A trained PCA based ELM model.}

\item{h}{Number of periods for forecasting. Defaults to one-step
ahead forecast.}
}
\value{
Vector of point forecasts.
}
\description{
Forecasts are generated recursively from a trained Extreme Learning Machine
built using Principal Component Analysis.
}
\examples{
train_set <- head(price, 12*12)
test_set <- tail(price, 12)
pca.model <- pca.elm_train(train_data = train_set, lags = 12)
y_hat <- pca.elm_forecast(pca.elm_model = pca.model, h = length(test_set))
# Evaluation of the forecasts
if(require("forecast")) forecast::accuracy(y_hat, test_set)
}
\seealso{
\code{\link[=pca.elm_train]{pca.elm_train()}} for training an ICA based ELM model.
}
