% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDEfunctions.R
\name{show_kernel}
\alias{show_kernel}
\title{Show IDE kernel}
\usage{
show_kernel(IDEmodel, scale = 1)
}
\arguments{
\item{IDEmodel}{object of class \code{IDE}}

\item{scale}{factor by which to scale the arrows when visualising a spatially-varying kernel}
}
\description{
Plotting function for visualising the IDE kernel.
}
\details{
The function \code{show_kernel} adapts its behaviour to the type of kernel. If the kernel is spatially-invariant, then the kernel with \eqn{s} evaluated at the origin is plotted. If spatially-variant, then arrows on a regular grid over the domain are plotted. The direction of the arrow is indicative of the transport direction at a specific location, while the length of the arrow is indicative of the transport intensity.
}
\examples{
SIM1 <- simIDE(T = 5, nobs = 100, k_spat_invariant = 0)
\donttest{show_kernel(SIM1$IDEmodel)}
}
\seealso{
\code{\link{IDE}} for details on the IDE model.
}
