% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Finalised_coding.R
\name{win_pcm_th}
\alias{win_pcm_th}
\title{A windows-based approach for multiple change-point detection in the mean via
thresholding}
\usage{
win_pcm_th(xd, sigma = stats::mad(diff(xd)/sqrt(2)), thr_con = 1,
  c_win = 3000, w_points = 3, l_win = 12000)
}
\arguments{
\item{xd}{A numeric vector containing the data in which you would like to find
change-points.}

\item{sigma}{A positive real number. It is the estimate of the standard deviation
of the noise in \code{xd}. The default value is the median absolute deviation of \code{xd}
computed under the assumption that the noise is independent and identically distributed
from the Gaussian distribution.}

\item{thr_con}{A positive real number with default value equal to 1. It is
used to define the threshold, which is equal to \code{sigma * thr_con * sqrt(2 * log(T))},
where \code{T} is the length of the data sequence \code{xd}.}

\item{c_win}{A positive integer with default value equal to 3000. It is the length
of each window for the data sequence in hand. Isolate-Detect will be applied
in segments of the form \code{[(i-1) * c_win + 1, i * c_win]}, for \eqn{i=1,2,...,K},
where \eqn{K} depends on the length \code{T} of the data sequence.}

\item{w_points}{A positive integer with default value equal to 3. It defines
the distance between two consecutive end- or start-points of the right- or
left-expanding intervals, respectively.}

\item{l_win}{A positive integer with default value equal to 12000. If the length of
the data sequence is less than or equal to \code{l_win}, then the windows-based approach
will not be applied and the result will be obtained by the classical Isolate-Detect
methodology based on thresholding.}
}
\value{
A numeric vector with the detected change-points.
}
\description{
This function performs the windows-based variant of the Isolate-Detect methodology
with the thresholding-based stopping rule in order to detect multiple change-points
in the mean of a noisy data sequence, with noise that is Gaussian. It is particularly
helpful for very long data sequences, as due to applying Isolate-Detect on moving windows,
the computational time is reduced. See Details for a brief explanation of this approach and
for the relevant literature reference.
}
\details{
The method that is implemented by this function is based on splitting the given
  data sequence uniformly into smaller parts (windows), to which Isolate-Detect, based on the
  threshold stopping rule (see \code{\link{pcm_th}}), is then applied. An idea of the computational
  improvement that this structure offers over the classical Isolate-Detect in the case of large data
  sequences is given in the supplement of ``Detecting multiple generalized change-points by isolating
  single ones'', Anastasiou and Fryzlewicz (2018), preprint.
}
\examples{
single.cpt <- c(rep(4,1000),rep(0,1000))
single.cpt.noise <- single.cpt + rnorm(2000)
cpt.single.th <- win_pcm_th(single.cpt.noise)

three.cpt <- c(rep(4,4000),rep(0,4000),rep(-4,4000),rep(1,4000))
three.cpt.noise <- three.cpt + rnorm(16000)
cpt.three.th <- win_pcm_th(three.cpt.noise)
}
\seealso{
\code{\link{pcm_th}}, which is the function that \code{\link{win_pcm_th}} is based on. Also,
see \code{\link{ID_pcm}} and \code{\link{ID}}, which employ \code{\link{win_pcm_th}}. In addition,
see \code{\link{win_cplm_th}} for the case of detecting changes in the slope of a
piecewise-linear and continuous signal via thresholding.
}
\author{
Andreas Anastasiou, \email{a.anastasiou@lse.ac.uk}
}
