% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inversionModel.R
\name{inversionModel}
\alias{inversionModel}
\title{Function to invert model, so amenities, wages, productivities, and development density
are chosen to match model to data.}
\usage{
inversionModel(
  N,
  L_i,
  L_j,
  Q,
  K,
  t_ij,
  alpha = 0.7,
  beta = 0.7,
  theta = 7,
  delta = 0.3585,
  rho = 0.9094,
  lambda = 0.01,
  epsilon = 0.01,
  mu = 0.3,
  eta = 0.1548,
  nu_init = 0.005,
  tol = 10^-10,
  maxiter = 1000,
  verbose = FALSE
)
}
\arguments{
\item{N}{Integer - Number of locations.}

\item{L_i}{Nx1 matrix - Number of residents in each location.}

\item{L_j}{Nx1 matrix - Number of workers in each location.}

\item{Q}{Nx1 matrix - Floorspace prices}

\item{K}{Nx1 matrix - Land area}

\item{t_ij}{NxN matrix - Travel times across all possible locations.}

\item{alpha}{Float - Utility parameter that determines preferences for
consumption.}

\item{beta}{Float - Output elasticity wrt labor}

\item{theta}{Float - Commuting elasticity and migration elasticity.}

\item{delta}{Float - Decay parameter agglomeration}

\item{rho}{Float - Decay parameter congestion}

\item{lambda}{Float - Agglomeration force}

\item{epsilon}{Float - Parameter that transforms travel times to commuting costs}

\item{mu}{Float - Floorspace prod function: output elast wrt capital, 1-mu wrt land.}

\item{eta}{Float - Congestion force}

\item{nu_init}{Float - Convergence parameter to update wages.
Default nu=0.01.}

\item{tol}{Int - tolerance factor}

\item{maxiter}{Integer - Maximum number of iterations for convergence.
Default maxiter=1000.}

\item{verbose}{Boolean - Equal to TRUE to print verbose.}
}
\value{
Equilibrium values.
}
\description{
Function to invert model, so amenities, wages, productivities, and development density
are chosen to match model to data.
}
\examples{
N=5
L_i = c(63, 261, 213, 182, 113)
L_j = c(86, 278, 189, 180, 99)
Q = c(2123, 1576, 1371, 1931, 1637)
K = c(0.44, 1.45, 1.15, 0.87, 0.58)
t_ij = rbind(c(0.0, 6.6, 5.5, 5.6, 6.4),
             c(6.7, 0.0, 3.9, 4.6, 4.4),
             c(5.5, 3.9, 0.0, 2.8, 3.0),
             c(5.6, 4.6, 2.8, 0.0, 2.7),
             c(6.4, 4.4, 3.0, 2.7, 0.0))

inversionModel(N=N,
               L_i=L_i,
               L_j=L_j,
               Q=Q,
               K=K,
               t_ij=t_ij)
               
}
