% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_data.R
\name{collapse_data}
\alias{collapse_data}
\title{Collapses data for a given collapsing function}
\usage{
collapse_data(data, collapse, constraint)
}
\arguments{
\item{data}{A dataset with J columns and n rows.}

\item{collapse}{A list of length J indicating the scoring function to collapse from.}

\item{constraint}{Constraint is either "rasch" or "gpcm" depending on which parameter constraints should be run.}
}
\value{
A list containing the collapsed data and a indicator vector for which parameters to test with the IMT. If no collapsing has occurred, the default indicator vector tests all parameters of the last item.
}
\description{
Collapses data for a given collapsing function
}
\examples{
data(dataset)
collapse = split(rep(c(1:4), 10), rep(1:10, each = 4))
my_data = collapse_data(dataset, collapse, "rasch")
# See vignette("IMT-vignette") for more examples.
}
