% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newfriki.R
\name{newfriki}
\alias{newfriki}
\title{Isolates values which are not continuous in the distribution}
\usage{
newfriki(date, value, margina = 0.999, times = 2)
}
\arguments{
\item{date}{vector of dates with the ECA&D format yyyymmdd}

\item{value}{vector of data values}

\item{margina}{tolerance margin, expressed as quantile of the differences}

\item{times}{multiplier for the tolerance margin. Intended usage is to run this twice.
Once with times = 1 and flag values as suspect; once with times = 2 and flag as error}
}
\value{
positions which do not pass this QC test
}
\description{
The function isolates extreme values which are not continuous in the distribution. If
the gap is larger (or smaller) than a pre-set big margin, the values above (or below) are flagged
}
\examples{
#Extract the ECA&D data file from the example data folder
path2inptfl<-system.file("extdata", "TX_SOUID132734.txt", package = "INQC")
#Read the data file
date<-readecad(input=path2inptfl,missing= -9999)[,3]
value<-readecad(input=path2inptfl,missing= -9999)[,4]
#Find all suspicious positions in the time series
newfriki(date,value,margina=0.999,times=1)
}
