% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dir_info2020}
\alias{dir_info2020}
\title{Directory Info 2020 Data}
\format{
A data frame of 6220 rows representing institutions and 47 variables

\describe{
\item{INSTITUTION_ID}{Unique identification number of the institution}
\item{INSTITUTION}{Institution (entity) name}
\item{ADDRESS}{Street address or post office box}
\item{CITY}{City location of institution}
\item{STATE}{State abbreviation}
\item{ZIP}{ZIP code}
\item{FIPS}{FIPS state code}
\item{BEA_REG}{Bureau of Economic Analysis (BEA) regions} (0 = US Service Schools; 1 = New England CT ME MA NH RI VT; 2 = Mid East DE DC MD NJ NY PA; 3 = Great Lakes IL IN MI OH WI; 4 = Plains IA KS MN MO NE ND SD; 5 = Southeast AL AR FL GA KY LA MS NC SC TN VA WV; 6 = Southwest AZ NM OK TX; 7 = Rocky Mountains CO ID MT UT WY; 8 = Far West AK CA HI NV OR WA; 9 = Outlying areas AS FM GU MH MP PR PW VI; -3 = Not available)
\item{AID_ELIG}{OPE Title IV eligibility indicator code (1 = Participates in Title IV federal financial aid programs; 2 = Branch campus of a main campus that participates in Title IV; 3 = Deferment only - limited participation; 5 = Not currently participating in Title IV, has an OPE ID number; 6 = Not currently participating in Title IV, does not have OPE ID number; 7 = Stopped participating during the survey year; 8 = New participants (became eligible during spring collection)}
\item{WEBSITE}{Institution's internet website address}
\item{ADMIN_WEB}{Admissions office web address}
\item{FINAID_WEB}{Financial aid office web address}
\item{APPLICATION}{Online application web address}
\item{NPRICE_CALC}{Net price calculator web address}
\item{VET_TUITION}{Veterans and Military Servicemembers tuition policies web address}
\item{ATH_GRAD_RATE}{Student-Right-to-Know student athlete graduation rate web address}
\item{DISABILITY_WEB}{Disability Services Web Address}
\item{INT_LEVEL}{Level of institution (1 = Four or more years; 2 = At least 2 but less than 4 years; 3 = Less than 2 years (below associate); -3 = {Not available})}
\item{INT_CONTROL}{Control of institution (1 = Public; 2 = Private not-for-profit; 3 = Private for-profit; -3 = {Not available})}
\item{UNGRAD_OFFER}{Undergraduate offering (1 = Undergraduate degree or certificate offering; 2 = No undergraduate offering; -3 = {Not available})}
\item{GRAD_OFFER}{Graduate offering (1 = Graduate degree or certificate offering; 2 = No graduate offering; -3 = {Not available})}
\item{HD_OFFER}{Degree-granting status (1 = Degree granting; 2 = Nondegree-granting, primarily post-secondary; -3 = {Not available})}
\item{HBCU}{Historically Black College or University (1 = Yes; 2 = No)}
\item{HOSPITAL}{Institution has hospital (1 = Yes; 2 = No; -1 = Not reported; -2 = Not applicable)}
\item{MEDICAL}{Institution grants a medical degree (1 = Yes; 2 = No; -1 = Not reported; -2 = Not applicable)}
\item{TRIBAL}{Tribal college (1 = Yes; 2 = No)}
\item{LOCALE}{Degree of urbanization (Urban-centric locale) (11 = City: Large; 12 = City: Midsize; 13 = City: Small; 21 = Suburb: Large; 22 = Suburb: Midsize; 23 = Suburb: Small; 31 = Town: Fringe; 32 = Town: Distant; 33 = Town: Remote; 41 = Rural: Fringe; 42 = Rural: Distant; 43 = Rural: Remote; -3 = {Not available})}
\item{OPENPUBL}{Institution open to the general public (1 = Institution is open to the public; 0 = Institution is not open to the public)}
\item{INT_STATUS}{Status of institution (A = Active; N = New(active) - added during the current year; R = Restore(active) restored to the current universe; M = Closed in current year (active has data); C = Combined with other institution; D = Delete out of business; G = Perfect child campus - data reported with main campus, but is listed on college navigator)}
\item{CLOSE_DATE}{Date institution closed}
\item{POST_SEC}{Postsecondary institution indicator (1 = Primarily postsecondary institution; 2 = Not primarily postsecondary)}
\item{RPTMTH}{Reporting method for student charges, graduation rates, retention rates and student financial aid (1 = Student charges for full academic year and fall GR/SFA/retention rate cohort; 2 = Student charges by program and full-year GR/SFA/retention rate cohort; 3 = Student charges for full academic year and full-year GR/SFA/retention rate cohort; -1 = Not reported; -2 = Not applicable)}
\item{CC_U2018}{Carnegie Classification 2018: Undergraduate Instructional Program (1 = Associate's Colleges: High Transfer; 2 = Associate's Colleges: Mixed Transfer/Career & Technical; 3 = Associate's Colleges: High Career & Technical; 4 = Special Focus: Two-Year Institution; 5 = Baccalaureate/Associates Colleges; 6 = Arts & sciences focus, no graduate coexistence; 7 = Arts & sciences focus, some graduate coexistence; 8 = Arts & sciences focus, high graduate coexistence; 9 = Arts & sciences plus professions, no graduate coexistence; 10 = Arts & sciences plus professions, some graduate coexistence; 11 = Arts & sciences plus professions, high graduate coexistence; 12 = Balanced arts & sciences/professions, no graduate coexistence; 13 = Balanced arts & sciences/professions, some graduate coexistence; 14 = Balanced arts & sciences/professions, high graduate coexistence; 15 = Professions plus arts & sciences, no graduate coexistence; 16 = Professions plus arts & sciences, some graduate coexistence; 17 = Professions plus arts & sciences, high graduate coexistence; 18 = Professions focus, no graduate coexistence; 19 = Professions focus, some graduate coexistence; 20 = Professions focus, high graduate coexistence; 0 = Not Classified (Exclusively Graduate Programs); -2 = Not applicable, not in Carnegie universe (not accredited or nondegree-granting))}
\item{CC_G2018}{Carnegie Classification 2018: Graduate Instructional Program (1 = Postbaccalaureate: Single program-Education; 2 = Postbaccalaureate: Single program-Business; 3 = Postbaccalaureate: Single program-Other; 4 = Postbaccalaureate: Comprehensive programs; 5 = Postbaccalaureate: Arts & sciences-dominant; 6 = Postbaccalaureate: Education-dominant, with Arts & Sciences; 7 = Postbaccalaureate: Business-dominant, with Arts & Sciences; 8 = Postbaccalaureate: Other-dominant, with Arts & Sciences; 9 = Postbaccalaureate: Education-dominant, with other professional programs; 10 = Postbaccalaureate: Business-dominant, with other professional programs; 11 = Postbaccalaureate: Other-dominant, with other professional programs; 12 = Research Doctoral: Single program-Education; 13 = Research Doctoral: Single program-Other; 14 = Research Doctoral: Comprehensive programs, with medical/veterinary school; 15 = Research Doctoral: Comprehensive programs, no medical/veterinary school; 16 = Research Doctoral: Humanities/social sciences-dominant; 17 = Research Doctoral: STEM-dominant; 18 = Research Doctoral: Professional-dominant; 0 = Not classified (Exclusively Undergraduate); -2 =  Not applicable, not in Carnegie universe (not accredited or nondegree-granting))}
\item{CC18_U_PROFILE}{Carnegie Classification 2018: Undergraduate Profile (1 = Two-year, higher part-time; 2 = Two-year, mixed part/full-time; 3 = Two-year, medium full-time; 4 = Two-year, higher full-time; 5 = Four-year, higher part-time; 6 = Four-year, medium full-time, inclusive, lower transfer-in; 7 = Four-year, medium full-time, inclusive, higher transfer-in; 8 = Four-year, medium full-time, selective, lower transfer-in; 9 = Four-year, medium full-time , selective, higher transfer-in; 10 = Four-year, full-time, inclusive, lower transfer-in; 11 = Four-year, full-time, inclusive, higher transfer-in; 12 = Four-year, full-time, selective, lower transfer-in; 13 = Four-year, full-time, selective, higher transfer-in; 14 = Four-year, full-time, more selective, lower transfer-in; 15 = Four-year, full-time, more selective, higher transfer-in; 0 = Not classified (Exclusively Graduate); -2 = Not applicable, not in Carnegie universe (not accredited or nondegree-granting))}
\item{CC18_ENROLL}{Carnegie Classification 2018: Enrollment Profile (1 = Exclusively undergraduate two-year; 2 = Exclusively undergraduate 4-year; 3 = Very high undergraduate; 4 = High undergraduate; 5 = Majority undergraduate; 6 = Majority graduate; 7 = Exclusively graduate; 8 = Not applicable)}
\item{CC18_SIZE_SET}{Carnegie Classification 2018: Size and Setting (1 = Two-year, very small; 2 = Two-year, small; 3 = Two-year, medium; 4 = Two-year, large; 5 = Two-year, very large; 6 = Four-year, very small, primarily nonresidential; 7 = Four-year, very small, primarily residential; 8 = Four-year, very small, highly residential; 9 = Four-year, small, primarily nonresidential; 10 = Four-year, small, primarily residential; 11 = Four-year, small, highly residential; 12 = Four-year, medium, primarily nonresidential; 13 = Four-year, medium, primarily residential; 14 = Four-year, medium, highly residential; 15 = Four-year, large, primarily nonresidential; 16 = Four-year, large, primarily residential; 17 = Four-year, large, highly residential; 18 = Exclusively graduate/professional; -2 =  Not applicable, not in Carnegie universe (not accredited or nondegree-granting))}
\item{C_PROGRAMS}{Carnegie Classification 2000 (15 = Doctoral/Research Universities--Extensive; 16 = Doctoral/Research Universities--Intensive; 21 = Masters Colleges and Universities I; 22 = Masters Colleges and Universities II; 31 = Baccalaureate Colleges--Liberal Arts; 32 = Baccalaureate Colleges--General; 33 = Baccalaureate/Associates Colleges; 40 = Associates Colleges; 51 = Theological seminaries and other specialized faith-related institutions; 52 = Medical schools and medical centers; 53 = Other separate health profession schools; 54 = Schools of engineering and technology; 55 = Schools of business and management; 56 = Schools of art, music, and design; 57 = Schools of law; 58 = Teachers colleges; 59 = Other specialized institutions; 60 = Tribal colleges; -2 = Not applicable, not in Carnegie universe (not accredited or nondegree-granting))}
\item{INT_SIZE}{Institution size category (1	= Under 1,000; 2 = 1,000 - 4,999; 3	= 5,000 - 9,999; 4 = 10,000 - 19,999; 5	= 20,000 and above; -1 = Not reported; -2	= Not applicable)}
\item{MULT_ORG}{Multi-institution or multi-campus organization (1 = Institution is part of a multi-institution or multi-campus organization; 2 = Institution is NOT part of a multi-institution or multi-campus organization; -1 = Not reported; -2 = Not applicable)}
\item{MULT_ORG_NAME}{Name of multi-institution or multi-campus organization}
\item{MULT_ORG_CODE}{Identification number of multi-institution or multi-campus organization}
\item{COUNTYCD}{Fips County code}
\item{COUNTYNM}{County name}
\item{CONGRESS_DIS_ID}{State and 114TH Congressional District ID}
\item{LONGITUD}{Longitude location of institution}
\item{LATITUDE}{Latitude location of institution}
}
}
\source{
Download from Integrated Postsecondary Education Data System,
\url{https://nces.ed.gov/ipeds/datacenter/data/HD2020.zip}.
}
\usage{
dir_info2020
}
\description{
This file contains directory information for every institution in the 2020-21 IPEDS universe. Includes name, address, city, state, zip code and various URL links to the institution's home page, admissions, financial aid offices and the net price calculator. Identifies institutions as currently active, institutions that participate in Title IV federal financial aid programs for which IPEDS is mandatory. It also includes variables derived from the 2020-21 Institutional Characteristics survey, such as control and level of institution, highest level and highest degree offered and Carnegie classifications.
}
\details{
Provisional release data have undergone all NCES data quality control procedures. Data are imputed for nonresponding institutions.
}
\keyword{datasets}
