% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag_test_MG.R
\name{dag_test_MG}
\alias{dag_test_MG}
\title{dag_test_MG}
\usage{
dag_test_MG(
  X0,
  p,
  alpha,
  version = c("all", "any"),
  leaf_weights,
  sparse = FALSE
)
}
\arguments{
\item{X0}{a numeric matrix giving points corresponding to hypotheses.}

\item{p}{a numeric vector taking values in (0, 1] such that \code{length(p) == nrow(X0)}.}

\item{alpha}{a numeric value in (0, 1] specifying the Type I error rate.}

\item{version}{either \code{"all"}
for the all-parent version of the procedure or \code{"any"} for the any-parent version of the procedure.}

\item{leaf_weights}{optional weights for the leaf nodes. Would have to be a numeric vector
of the same length as there are leaf nodes in the DAG (resp. polytree, see \code{sparse}) induced by \code{X0}.}

\item{sparse}{a logical value specifying whether \code{X0} should be used to
induce a DAG (\code{FALSE}) or a polytree (\code{TRUE}).}
}
\value{
A boolean vector of the same length as \code{p} with each element being \code{TRUE} if the corresponding hypothesis is rejected and \code{FALSE} otherwise.
}
\description{
Implements the graph-testing procedures proposed by
\insertCite{meijer2015multiple;textual}{ISS} for one-way logical relationships.
Here implemented for the specific application to isotonic subgroup selection.
}
\examples{
X0 <- rbind(c(0.5, 0.6), c(0.8, 0.9), c(0.9, 0.8))
p <- c(0.02, 0.025, 0.1)
alpha <- 0.05
dag_test_MG(X0, p, alpha)
dag_test_MG(X0, p, alpha, version = "any")
dag_test_MG(X0, p, alpha, sparse = TRUE)

}
\references{
\insertRef{meijer2015multiple}{ISS}
}
