% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVC.R
\name{IVCTLLQ}
\alias{IVCTLLQ}
\title{Integrated Variance Correlation Based Hypothesis Test with Local Linear Estimation}
\usage{
IVCTLLQ(y, x, K, num_per)
}
\arguments{
\item{y}{is a numeric vector}

\item{x}{is a numeric vector}

\item{K}{is the number of quantile levels}

\item{num_per}{is the number of permutation times}
}
\value{
The p-value of the corresponding hypothesis test
}
\description{
This function is used to test significance using integrated variance correlation with local linear estimation
}
\examples{
n=100
x=runif(n,-1,1)
y=2*cos(2*x)+rnorm(n)

\donttest{
IVCTLLQ(y,x,K=5,num_per=100)
}
}
