% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unrReg.R
\name{coefficients.unrestricted}
\alias{coefficients.unrestricted}
\alias{coef.unrestricted}
\title{Extract Model Coefficients}
\usage{
\method{coefficients}{unrestricted}(object, ...)

\method{coef}{unrestricted}(object, ...)
}
\arguments{
\item{object}{An object of class \code{unrestricted}.}

\item{...}{Other arguments.}
}
\value{
A vector of coefficients.
}
\description{
Coefficients extracted from the model object \code{unrestricted}.
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
model <- unrReg(X, y)
coefficients(model)
coef(model)
}
\seealso{
\code{\link{coefficients.restricted}},
\code{\link{coefficients.preliminaryTest}},
\code{\link{coefficients.improvedpreliminaryTest}},
\code{\link{coefficients.stein}},
\code{\link{coefficients.positivestein}},
\code{\link{coef.restricted}},
\code{\link{coef.preliminaryTest}},
\code{\link{coef.improvedpreliminaryTest}}
\code{\link{coef.stein}},
\code{\link{coef.positivestein}}.
}
