% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unrReg.R
\name{residuals.unrestricted}
\alias{residuals.unrestricted}
\title{Extract Model Residuals}
\usage{
\method{residuals}{unrestricted}(object, ...)
}
\arguments{
\item{object}{An object of class \code{unrestricted}.}

\item{...}{Other arguments.}
}
\value{
A vector of residuals.
}
\description{
Residuals values based on model object \code{unrestricted}.
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
model <- unrReg(X, y)
residuals(model)
}
\seealso{
\code{\link{residuals.restricted}},
\code{\link{residuals.preliminaryTest}},
\code{\link{residuals.improvedpreliminaryTest}}
\code{\link{residuals.stein}},
\code{\link{residuals.positivestein}}.
}
