% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lackinfo.R
\docType{data}
\name{lackinfo}
\alias{lackinfo}
\title{Lack of information in expository face-to-face lessons data set}
\format{
A data frame with 50 observations of the following 12 variables:
\itemize{
\item \code{id}: identification number.
\item \code{sex}: sex of the respondent (\code{male} or \code{female}).
\item \code{inf1}: infimum of respondent's interval-valued
answer to item 1.
\item \code{sup1}: supremum of respondent's interval-valued
answer to item 1.
\item \code{inf2}: infimum of respondent's interval-valued
answer to item 2.
\item \code{sup2}: supremum of respondent's interval-valued
answer to item 2.
\item \code{inf3}: infimum of respondent's interval-valued
answer to item 3.
\item \code{sup3}: supremum of respondent's interval-valued
answer to item 3.
\item \code{inf4}: infimum of respondent's interval-valued
answer to item 4.
\item \code{sup4}: supremum of respondent's interval-valued
answer to item 4.
\item \code{inf5}: infimum of respondent's interval-valued
answer to item 5.
\item \code{sup5}: supremum of respondent's interval-valued
answer to item 5.
}
}
\usage{
lackinfo
}
\description{
A data set containing the interval-valued responses to 5 different items
measuring the perception of lack of information in expository face-to-face
lessons obtained with a questionnaire carried out at the University of Oviedo
(Spain). Respondents sex is also included.
}
\details{
An educational innovation project was carried out for improving
teaching-learning processes at the University of Oviedo (Spain)
for the 2020/2021 academic year. A total of 50 students have been
requested to answer an online questionnaire about their perception
of lack of information in expository face-to-face lessons by selecting the
interval that best represents their level of agreement to the
statements proposed in a interval-valued scale bounded between 1 and 7,
where 1 means \emph{strongly disagree} and 7 represents the option
\emph{strongly agree}.

These are the 5 items used to measure the perception of the
students about the lack of information in expository face-to-face lessons:
\enumerate{
\item I receive too little information from my classmates.
\item It is difficult to receive relevant information from my classmates.
\item It is difficult to receive relevant information from the teacher.
\item The amount of information I receive from my classmates is very low.
\item The amount of information I receive from the teacher is very low.
}

Moreover, the students have been requested to indicate their sex too.
}
\examples{
## Real-life data set with interval-valued responses to a questionnaire

## Load the data set
data(lackinfo, package = "IntervalQuestionStat")

## Explore the data set: first rows, structure, and summary
head(lackinfo)
str(lackinfo)
summary(lackinfo)
}
\keyword{datasets}
