% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-show.R
\docType{methods}
\name{show}
\alias{show}
\alias{show,IntervalData-method}
\alias{show,IntervalList-method}
\alias{show,IntervalMatrix-method}
\title{Print basic information of interval-valued data}
\usage{
\S4method{show}{IntervalData}(object)

\S4method{show}{IntervalList}(object)

\S4method{show}{IntervalMatrix}(object)
}
\arguments{
\item{object}{A single interval, a list of intervals or a matrix with several
intervals stored as an \code{IntervalData},
\code{IntervalList}, or \code{IntervalMatrix} object.}
}
\value{
This function does not return any value. It only prints the interval-valued
object's information.
}
\description{
This function allows to print in the console
basic information of interval-valued data.
}
\details{
For \code{IntervalData} and \code{IntervalList} objects, both \emph{inf/sup}
and \emph{mid/spr} characterizations of the intervals are printed, and
for \code{IntervalMatrix} instances, the number of rows and
columns is shown.
}
\examples{
## Show an interval-valued data
i <- IntervalData(0, 1)
show(i)

## Show an interval-valued data list
list <- IntervalList(c(0, 3, 2, 5, 6), c(4, 5, 4, 8, 7))
show(list)

## Show an interval-valued data matrix
m <- IntervalMatrix(matrix(c(0, 1, 2, 3, 0, 3, 4, 9), 2, 4))
show(m)
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
