% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chain-simulation.R
\name{chain_simulate_Isingland}
\alias{chain_simulate_Isingland}
\alias{make_Ising_chain}
\title{Make Ising chains from (a series of) Ising grid(s) and perform a
chain simulation.}
\usage{
chain_simulate_Isingland(
  Ising_chain,
  transform = FALSE,
  initial = 0,
  beta2 = NULL
)

make_Ising_chain(...)
}
\arguments{
\item{Ising_chain}{An    \code{Ising_chain} object generated from \code{make_Ising_chain()}.}

\item{transform}{By default, this function considers the Ising network
to use \code{-1} and \code{1} for two states. Set \code{transform = TRUE} if the Ising
network uses \code{0} and \code{1} for two states, \emph{which is often the case for the
Ising networks estimated using} \code{\link[IsingFit:isingfit]{IsingFit::IsingFit()}}.}

\item{initial}{An integer indicating the initial number
of active nodes for the simulation. Float numbers will be
converted to an integer automatically.}

\item{beta2}{The \eqn{beta} value used for simulation. By default use
the same value as for landscape construction. Manually setting this
value can make the system easier or more difficult to transition
to another state, but will alter the steady-state distribution as well.}

\item{...}{Ising grid(s) created by \code{\link[=make_Ising_grid]{make_Ising_grid()}}.}
}
\value{
\code{make_Ising_chain} returns an \code{Ising_chain} object, which is a tibble, and each row
represents a set of parameters for an Ising network.

\code{chain_simulate_Isingland} returns a \code{chain_sim_Isingland} object,
which is a tibble containing the parameters, the landscape, and
the number of active nodes for each time step.
}
\description{
First specify what is the network parameter in each time points, then
perform a chain simulation based on it. An Ising chain can be generated
from one or more Ising grid(s) with one changing condition each.
}
