% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.survfitJMMLSM.R
\name{plot.survfitJMMLSM}
\alias{plot.survfitJMMLSM}
\title{Plot conditional probabilities for new subjects}
\usage{
\method{plot}{survfitJMMLSM}(
  x,
  include.y = FALSE,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim.long = NULL,
  ylim.surv = NULL,
  ...
)
}
\arguments{
\item{x}{x of class \code{survfitJMMLSM}.}

\item{include.y}{include longitudinal responses of this subject versus time. Default is FALSE.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{xlim}{X axis support.}

\item{ylim.long}{Y axis support for the longitudinal outcome.}

\item{ylim.surv}{Y axis support for the event / survival probability.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
plots of conditional probabilities over different pre-specified time points for subjects. 
If single failure type, then survival probabilities will be returned. 
Otherwise, cumulative incidence probabilities for each failure type will be returned.
}
\description{
Plot conditional probabilities for new subjects. 
If \code{CompetingRisk = FALSE}, print the survival probabilities. 
Otherwise, print the cumulative incidence probabilities for each failure type.
}
\seealso{
\code{\link{survfitJMMLSM}}
}
\author{
Shanpeng Li \email{lishanpeng0913@ucla.edu}
}
