% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EvaluatePanel.R
\name{EvaluatePanel}
\alias{EvaluatePanel}
\title{Evaluate a panel}
\usage{
EvaluatePanel(
  type = "csv",
  strpath,
  raremode = "ISFG",
  Nind = "lastrow",
  Th = 0.01
)
}
\arguments{
\item{type}{The type of input data, either 'csv'(a .csv containing af matrix, with the marker names listed in the first row), or 'df' (a data frame cantaining the af matrix with the marker names as column names)}

\item{strpath}{pathway of the .csv file or the name of the data frame}

\item{raremode}{mode of the calculation method of rare alleles, with a default of "ISFG", indicating the recommended method from ISFG, i.e., (X+1)/(2N+1), where X and N stood for the number of allele types detected in a survey and the sample size, respectively. Three alternative methods are given: "MAF", take the minimum allele frequency as such frequency; "1/2N", take the minimum of possible frequency a survey can achieved; and a number .}

\item{Nind}{mode of sample size, with a default of "lastrow", meaning that the sample size was presented in the last row of the .csv file. An alternative method is given, i.e., input a unified sample size.}

\item{Th}{The threshold for the difference in allele frequency sum at a locus with 1, to detect data error from rounding error when the frequency sum does not equal 1. Loci exceeding this threshold will be excluded from the calculation.}
}
\value{
list of four vectors: afmatrix, a list of allele frequency data of each locus; rare, a data.frame containing the frequency of rare allele on each locus; indicators, a data.frame containing parameters of system efficiency for each locus; panelparas, a data.frame containing system efficiency parameters for the whole panel, with the form of log10(1-paramter) to avoid the situation that the parameters being displayed as 1 because they were too close to 1
}
\description{
Transfer the input allele frequency data (in a .csv file or a data frame) into form usable for other functions and then calculate several population parameters based on the frequency data for each marker.
}
\examples{
#A .csv file can be output with FortytwoSTR data
path<-tempdir()
outputCSV(FortytwoSTR,file.path(path,'data.csv'))
#Example 1, 'df' type, by read the csv file into a data frame
allele_data <- read.csv(file = file.path(path,'data.csv'), header = TRUE)
STR42<- EvaluatePanel(type = 'df',strpath = allele_data,raremode = "ISFG",Nind = "lastrow")
#Example 2, 'csv' type, the same evaluation can be done by directly input the csv file
STR42_2 <- EvaluatePanel(type = 'csv',strpath = file.path(path,'data.csv'),
raremode = "ISFG",Nind = "lastrow")
#The data "FortytwoSTR" is generated with these codes.
}
