% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/principal.component.R
\name{cal.pc.linear}
\alias{cal.pc.linear}
\title{Calculate linear principal component analysis (PCA) from numeric data and
Single-nucleotide polymorphism (SNP) dataset}
\usage{
cal.pc.linear(X, PCscore = TRUE, no.pc = NA, data.type = "linear", XXT = TRUE)
}
\arguments{
\item{X}{A data matrix which rows represent samples and columns represent
features.}

\item{PCscore}{To specify whether scaled PCs will be calculated or not. If
FALSE, eigenvectors are returned instead. Default = TRUE.}

\item{no.pc}{A number of PCs to be calculated. If no.pc is set, PCs are
patially calculated. Otherwise all PCs are obtained after calculation.
Default = NA.}

\item{data.type}{To specify a type of data matrix X. It can be set to
"linear" and "snp". Default = "linear".}

\item{XXT}{To specify how pricipal components (PCs) are calculated. If TRUE,
PCs are calculated from X.t(X), otherwise X is used directly. XXT is useful
option especially an input matrix X contains many columns. Enabling this
option, it helps to reduce computation complexity. Regardless the option XXT
is enable or not, optained PCs are the same. Default = TRUE.}
}
\value{
The returned value is a list with 2 objects, \code{$PC},
\code{$evalue}:
\itemize{
\item \code{$PC} is a PC matrix which rows represent samples and columns
represent PCs.
\item \code{$evalue} is a vector of eigen values.
}
}
\description{
Available for two types of data; numeric data and
Single-nucleotide polymorphism (SNP) dataset in additive coding (0, 1, and 2).
}
\examples{

#Load simulated dataset
data(example_SNP)

#Using default parameters
PCs <- cal.pc.linear(simsnp$snp)
summary(PCs)

#Preview $PC
print(PCs$PC[1:5,1:3])

#Preview $evalue
print(PCs$evalue[1:3])

plot3views(PCs$PC[,1:3], sample_labels)

#Calculate PCs without PC scores

PCs <- cal.pc.linear(simsnp$snp, PCscore = FALSE)
summary(PCs)

#Preview $PC
print(PCs$PC[1:5,1:3])

#Preview $evalue
print(PCs$evalue[1:3])

plot3views(PCs$PC[,1:3], sample_labels)

#Calculate the top 3 PCs
PCs <- cal.pc.linear(simsnp$snp, no.pc = 3)
summary(PCs)

#Preview $PC
print(PCs$PC[1:5,1:3])

#Preview $evalue
print(PCs$evalue[1:3])

plot3views(PCs$PC[,1:3], sample_labels)
}
\seealso{
\code{\link{cal.pc.projection}}
}
