% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simsnp}
\alias{simsnp}
\title{Synthetic dataset containing single nucleotide polymorphisms (SNP)}
\format{
A list with 3 objects
}
\usage{
data(example_SNP)
}
\description{
The simsnp is the simulated dataset which consists of 3,000 independent SNPs
and 753 individuals belonging to one of three populations (250 individuals
each) and 3 outlying individuals. The pairwise genetic distance between
populations was set to Fst=0.01 as in Balding (1995).
}
\details{
\describe{
\item{ind.info}{A character matrix of 753 rows and 6 columns representing
individuals and individual information respectively. The columns of
ind.info represents sample_ID, family_ID, father_ID, mother_ID, gender,
and phenotype respectively.}
\item{snp.info}{A character matrix of 3,000 rows and 6 columns representing
SNPs and SNP information respectively. The columns of snp.info represents
SNP_CHR (chromosome), SNP_ID, centimorgan, position, allele1, and allele2
respectively.}
\item{snp}{A numeric matrix of 753 rows and 3,000 columns representing
individuals and SNPs respectively. The matrix snp contains the number 0, 1,
and 2 representing SNP in additive coding.}
}
}
\references{
Balding, D.J., and Nichols, R.A. (1995). A method for quantifying
differentiation between populations at multi-allelic loci and its
implications for investigating identity and paternity. Genetica 96, 3-12.
}
\seealso{
\code{\link{sample_labels}}
}
\keyword{simsnp}
