% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmm.R
\name{plotgmm}
\alias{plotgmm}
\title{Plots histogram for 1-d GMM given the dataset}
\usage{
plotgmm(data, mu = NULL)
}
\arguments{
\item{data}{(n by 1): The dataset of interest,
where n is the number of samples.}

\item{mu}{: True mean of the GMM (optional)}
}
\description{
Plots histogram for 1-d GMM given the dataset
}
\examples{
# Plot pdf histogram for a given dataset
model <- gmm()
X <- rgmm(model)
plotgmm(data=X)

# Plot pdf histogram for a given dataset, with lines that indicate the mean
model <- gmm()
mu <- model$mu
X <- rgmm(model)
plotgmm(data=X, mu=mu)
}
