% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmm.R
\name{posteriorgmm}
\alias{posteriorgmm}
\title{Calculates the posterior probability for a given dataset for a GMM}
\usage{
posteriorgmm(model = NULL, X = NULL)
}
\arguments{
\item{model}{: The Gaussian Mixture Model}

\item{X}{(n by d): The dataset of interest,
where n is the number of samples and d is the dimension}
}
\value{
P (n by k) : The posterior probabilty of each dataset belonging to each of the k component
}
\description{
Calculates the posterior probability for a given dataset for a GMM
}
\examples{
# compute posterior probability for a default 1-d gaussian mixture model
# and dataset generated from it
model <- gmm()
X <- rgmm(model)
p <- posteriorgmm(model=model, X=X)
}
