% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmm.R
\name{rgmm}
\alias{rgmm}
\title{Generates dataset from Gaussian Mixture Model}
\usage{
rgmm(model = NULL, n = 100)
}
\arguments{
\item{model}{: Gaussian Mixture Model defined by gmm()}

\item{n}{: number of samples desired}
}
\value{
data (n by d): Random dataset generated from given the Gaussian Mixture Model
}
\description{
Generates dataset from Gaussian Mixture Model
}
\note{
Requires library mvtnorm
}
\examples{
#Generate 100 samples from default gaussian mixture model
model <- gmm()
X <- rgmm(model)

#Generate 300 samples from 3-d gaussian mixture model
model <- gmm(d=3)
X <- rgmm(model,n=300)
}
