% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooksDistanceKspm.R
\name{cooks.distance.kspm}
\alias{cooks.distance.kspm}
\title{Cook's distance for a Kernel Semi Parametric Model Fit}
\usage{
\method{cooks.distance}{kspm}(model, ...)
}
\arguments{
\item{model}{an model of class "kspm", usually, a result of a call to \code{kspm}.}

\item{...}{furter arguments passed to or from other methods (currently unused).}
}
\value{
A vector containing Cook's distance values.
}
\description{
Computes the Cook's distance method for an object of class "kspm".
}
\details{
Cook's distance values (\eqn{C_i}{C_i}) are computed as follows: \eqn{C_i = \frac{e_i^2 h_{ii}}{\hat{\sigma}^2 tr(H) (1-h_{ii})^2}}{C_i = (e_i^2  h_ii) / (hat(sigma^2)  tr(H)  (1-h_ii)^2)} where e_i is the residual of subject i, h_ii is the i th diagonal element of Hat matrix H corresponding to the leverage associated with subject i and tr(H) is the trace of the Hat matrix H.
}
\seealso{
\link{kspm} for fitting model, \link{residuals.kspm}, \link{rstandard.kspm}, \link{plot.kspm}.
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
