% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepKspm.R
\name{stepKSPM}
\alias{stepKSPM}
\title{Choose a model by AIC or BIC in a Stepwise Algorithm}
\usage{
stepKSPM(object, data = NULL, linear.lower = NULL,
  linear.upper = NULL, kernel.lower = NULL, kernel.upper = NULL,
  direction = "both", k = 2, kernel.param = "fixed", trace = TRUE)
}
\arguments{
\item{object}{an object of class "kspm" with only one kernel.}

\item{data}{data.}

\item{linear.lower}{one side formula corresponding to the smallest set of variables that should be included in the linear part of the model.}

\item{linear.upper}{one side formula corresponding to the largest set of variables that may be included in the linear part of the model.}

\item{kernel.lower}{one side formula corresponding to the smallest set of variables that should be included in the kernel part of the model.}

\item{kernel.upper}{one side formula corresponding to the  largest set of variables that may be included in the kernel part of the model.}

\item{direction}{the mode of stepwise search, can be one of "both" (default), "backward", or "forward".}

\item{k}{type of information criteria used for the variable selection. If \code{k=2} AIC is used (default), if \code{k=log(n)}, BIC is used instead.}

\item{kernel.param}{define if hyperparameters should be fixed (\code{"fixed"}) or reestimated at each iteration (\code{"change"}). Tu use the last option, hyperparameter of model provided in \code{object} should have been estimated by the model.}

\item{trace}{integer. If positive, information is printed during the running of step.kspm. Larger values may give more information on the fitting process.}
}
\value{
\code{stepKSPM} returns the selected model.
}
\description{
Performs stepwise model selection for Kernel Semi Parametric Model by AIC or BIC.
}
\details{
This procedure may be done on \code{kspm} object defined with only one kernel part and for which a data frame including all variables was provided. Selection may be done on linear part only, on kernel part only or on both at the same time. To perform selection on linear (resp. kernel) part only, \code{kernel.lower} and \code{kernel.upper} (resp. \code{linear.lower} and \code{linear.upper}) should contain all the variables that should stay in the model for kernel (resp. linear) part.
}
\examples{
x <- 1:15
z1 <- runif(15, 1, 6)
z2 <- rnorm(15, 1, 4)
z3 <- rnorm(15, 6, 2)
z4 <- runif(15, -10, 2)
y <- 3*x + (z1 + z2)^2 + rnorm(15, 0, 2)
dfrm <- data.frame(x = x, z1 = z1, z2 = z2, z3 = z3, z4 = z4, y = y)
fit <- kspm(y, linear = ~ x, kernel = ~ Kernel(~ z1 + z2 + z3 + z4,
kernel.function = "polynomial", d= 2, rho = 1, gamma = 0), data = dfrm)
stepKSPM(fit, k = 2, data = dfrm)

}
\seealso{
\link{extractAIC.kspm}
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
