#' @description
#' \tabular{ll}{
#' Package: \tab KenSyn\cr
#' Type: \tab Package\cr
#' Version: \tab 0.3\cr
#' Date: \tab 2019-04-08\cr
#' License: \tab LGPL-3 \cr
#' LazyLoad: \tab yes\cr
#' LazyData: \tab yes\cr
#' Depends: \tab R(>= 3.0.0)\cr
#' Imports: \tab nlme, lme4, metafor\cr
#' }
#'
#' \strong{KenSyn}
#' Knowledge Synthesis in Agriculture - From Experimental Network to Meta-Analysis.
#'
#' Demo and dataset accompaying the books :
#' 
#' \strong{De l'analyse des réseaux expérimentaux à la méta-analyse: Méthodes et applications avec le logiciel R pour les sciences agronomiques et environnementales} 
#' (Published 2018-06-28, Quae, for french version) by David Makowski, Francois Piraux and Francois Brun)
#' \url{https://www.quae.com/produit/1514/9782759228164/de-l-analyse-des-reseaux-experimentaux-a-la-meta-analyse}
#'
#' \strong{Knowledge Synthesis in Agriculture : from Experimental Network to Meta-Analysis}
#' (in preparation for 2018-06, Springer , for English version)
#' by David Makowski, Francois Piraux and Francois Brun)
#'
#' A full description of all the material is in both books.
#'
#' \strong{ACKNOWLEDGMENTS}
#' The French network "RMT modeling and data analysis for agriculture", \url{http://www.modelia.org}) have contributed to the development of this R package. This project and network are lead by ACTA (French Technical Institute for Agriculture) and was funded by a grant from the Ministry of Agriculture and Fishing of France.
#'
#' @name KenSyn-package
#' @aliases KenSyn
#' @docType package
#' @title Knowledge Synthesis in Agriculture - From Experimental Network to Meta-Analysis
#' @author  Francois Brun (ACTA)  \email{francois.brun@acta.asso.fr}, David Makowski (INRA), Francois Piraux (Arvalis)
#' @references Synthetiser la connaissance : de l'analyse de reseaux experimentaux a la meta-analyse
#' \url{http://www.modelia.org}
#' @keywords agricultural agronomy crop environment meta-analysis mixted-model
NA
