% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gensynthetic.R
\name{GenSynthetic}
\alias{GenSynthetic}
\title{Generate Synthetic Data}
\usage{
GenSynthetic(n, p, k, seed, rho = 0, b0 = 0, snr = 1)
}
\arguments{
\item{n}{Number of samples}

\item{p}{Number of features}

\item{k}{Number of non-zeros in true vector of coefficients}

\item{seed}{The seed used for randomly generating the data}

\item{rho}{The threshold for setting values to 0.  if |X(i, j)| > rho => X(i, j) <- 0}

\item{b0}{intercept value to translate y by.}

\item{snr}{desired Signal-to-Noise ratio. This sets the magnitude of the error term 'e'. 
SNR is defined as  SNR = Var(XB)/Var(e)}
}
\value{
A list containing:
 the data matrix X,
 the response vector y,
 the coefficients B,
 the error vector e,
 the intercept term b0.
}
\description{
Generates a synthetic dataset as follows: 1) Sample every element in data matrix X from N(0,1).
2) Generate a vector B with the first k entries set to 1 and the rest are zeros. 3) Sample every element in the noise
vector e from N(0,1). 4) Set y = XB + b0 + e.
}
\examples{
data <- GenSynthetic(n=100,p=20,k=10,seed=1)
X = data$X
y = data$y
}
