% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L2E_TF_dist.R
\name{L2E_TF_dist}
\alias{L2E_TF_dist}
\title{Solution path of the L2E trend filtering regression with distance penalization}
\usage{
L2E_TF_dist(
  y,
  X,
  beta0,
  tau0,
  D,
  kSeq,
  rhoSeq,
  max_iter = 100,
  tol = 1e-04,
  Show.Time = TRUE
)
}
\arguments{
\item{y}{Response vector}

\item{X}{Design matrix. Default is the identity matrix.}

\item{beta0}{Initial vector of regression coefficients, can be omitted}

\item{tau0}{Initial precision estimate, can be omitted}

\item{D}{The fusion matrix}

\item{kSeq}{A sequence of tuning parameter k, the number of nonzero entries in D*beta}

\item{rhoSeq}{An increasing sequence of tuning parameter rho, can be omitted}

\item{max_iter}{Maximum number of iterations}

\item{tol}{Relative tolerance}

\item{Show.Time}{Report the computing time}
}
\value{
Returns a list object containing the estimates for beta (matrix) and
tau (vector) for each value of the tuning parameter k,
the path of estimates for beta (list of matrices) and tau (matrix) for each value of rho,
the run time (vector) for each k,
and the sequence of rho and k used in the regression (vectors)
}
\description{
\code{L2E_TF_dist} computes the solution path of the robust trend filtering regression under the L2 criterion with distance penalty
}
\examples{
## Completes in 15 seconds

set.seed(12345)
n <- 100
x <- 1:n
f <- matrix(rep(c(-2,5,0,-10), each=n/4), ncol=1)
y <- y0 <- f + rnorm(length(f))

## Clean Data
plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5, col='gray')
lines(x, f, lwd=3)

D <- myGetDkn(1, n)
k <- c(4,3,2)
rho <- 10^8
# (not run)
# sol <- L2E_TF_dist(y=y, D=D, kSeq=k, rhoSeq=rho)

# plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5, col='gray')
# lines(x, f, lwd=3)
# lines(x, sol$Beta[,3], col='blue', lwd=3) ## k=2
# lines(x, sol$Beta[,2], col='red', lwd=3) ## k=3
# lines(x, sol$Beta[,1], col='dark green', lwd=3) ## k=4

## Contaminated Data
ix <- sample(1:n, 10)
y[ix] <- y0[ix] + 2

plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5, col='gray')
lines(x, f, lwd=3)

# (not run)
# sol <- L2E_TF_dist(y=y, D=D, kSeq=k, rhoSeq=rho)

# plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5, col='gray')
# lines(x, f, lwd=3)
# lines(x, sol$Beta[,3], col='blue', lwd=3) ## k=2
# lines(x, sol$Beta[,2], col='red', lwd=3) ## k=3
# lines(x, sol$Beta[,1], col='dark green', lwd=3) ## k=4

}
