% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverse_gaussian_tests.R
\name{inverse_gaussian_shape_one_sample}
\alias{inverse_gaussian_shape_one_sample}
\title{Test the shape parameter of an inverse gaussian distribution.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
inverse_gaussian_shape_one_sample(
  x,
  shape,
  alternative = "two.sided",
  conf.level = 0.95
)
}
\arguments{
\item{x}{a numeric vector of data.}

\item{shape}{a number indicating the tested value of the shape parameter.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test the shape parameter of an inverse gaussian distribution.
}
\examples{
library(LRTesteR)
library(statmod)

# Null is true
set.seed(1)
x <- rinvgauss(n = 100, mean = 1, shape = 2)
inverse_gaussian_shape_one_sample(x, 2, "two.sided")

# Null is false
set.seed(1)
x <- rinvgauss(n = 100, mean = 1, shape = 2)
inverse_gaussian_shape_one_sample(x, 1, "greater")
}
