% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Anthro_F.R
\docType{data}
\name{Anthro_F}
\alias{Anthro_F}
\title{Anthropometric data from college-aged women}
\format{
A data.frame with one row for each of 184 woman
\itemize{
\item Weight (kg)
\item Height (m)
\item BMI: (Body Mass Index) Weight divided by the square of Height
\item Age
\item Neck: Minimal circumference perpendicular to the long axis of the neck (cm)
\item Chest: Horizontal plane measurement at the sixth rib, at the end of a normal expiration (cm)
\item Calf: Horizontal maximal calf measurement (cm)
\item Biceps: Measurement with arm extended (cm)
\item Hips: Horizontal maximal measurement around buttocks (cm)
\item Waist: Horizontal minimal measurement, at the end of a normal expiration (cm)
\item Forearm: Maximal measurement perpendicular to long axis (cm)
\item PThigh: (Proximal Thigh) Horizontal measurement immediately distal to the gluteal furrow (cm)
\item MThigh: (Middle Thigh) Measurement midway between the midpoint of the inguinal crease and the proximal border of the patella (cm)
\item DThigh: (Distal Thigh) Measurement proximal to the femoral epicondyles (cm)
\item Wrist: Measurement perpendicular to the long axis of the forearm (cm)
\item Knee: Measurement at the mid-patellar level, with the knee slightly flexed (cm)
\item Elbow: A minimal circumference measurement with the elbow extended (cm)
\item Ankle: Minimal circumference measurement perpendicular to the long axis of the calf (cm)
\item BFat: Amount of body fat expressed as a percentage of total body weight, using Siri's (1956) method
}
}
\source{
Roger W. Johnson (2021) "Fitting Percentage of Body Fat to Simple Body Measurements: College Women"
\emph{Journal of Statistics and Data Science Education} \strong{29}(3) \doi{10.1080/26939169.2021.1971585}
}
\usage{
data(Anthro_F)
}
\description{
Percentage of body fat, age, weight, height, body mass index and fourteen
circumference measurements are given for 184 college women ages 18-25.
Body fat was accurately determined by an underwater weighing technique
which requires special equipment and training of the individuals
conducting the process. Circumference measurements were made to the
nearest 0.1 cm using a cloth tape in complete contact with the skin
but without compression of the soft tissues. The measurement process,
described somewhat incompletely below, is described in greater detail in
Slack (1997) who used the standards recommended by Lohman, Roche and
Martrell (1988).
}
\keyword{datasets}
