% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_eval.R
\name{model_eval}
\alias{model_eval}
\title{Evaluate a model on inputs}
\usage{
model_eval(
  mod,
  data = NULL,
  ...,
  skeleton = FALSE,
  ncont = 3,
  interval = c("prediction", "confidence", "none"),
  level = 0.95,
  type = c("response", "link")
)
}
\arguments{
\item{mod}{A model as from \code{model_train()}, \code{lm()} or \code{glm()}}

\item{data}{A data frame of inputs. If missing, the inputs will be assembled from \ldots or
from the training data, or an skeleton will be constructed.}

\item{skeleton}{Logical flag. If \code{TRUE}, a skeleton on inputs will be created. See \code{\link[=model_skeleton]{model_skeleton()}}.}

\item{ncont}{Only relevant to skeleton. The number of levels at which to evaluate continuous variables. See  \code{\link[=model_skeleton]{model_skeleton()}}.}

\item{interval}{One of "prediction" (default), "confidence", or "none".}

\item{level}{The level at which to construct the interval (default: 0.95)}

\item{type}{Either "response" (default) or "link". Relevant only to glm models. The format of the \code{.output}}

\item{\ldots}{Optional vectors specifying the inputs. See examples.}
}
\value{
A data frame. There is one row for each row of the input values (see \code{data} parameter). The
columns include
\itemize{
\item the explanatory variables
\item \code{.output} --- the output of the model that corresponds to the explanatory value
\item the \code{.lwr} and \code{.upr} bounds of the prediction or confidence interval
\item if training data is used as the input, then it's possible to calculate the residual. This
will be called \code{.resid}.
}
}
\description{
Evaluate a model on inputs
}
\examples{
mod <- mtcars |> model_train(mpg ~ hp + wt)
model_eval(mod, hp=100, wt=c(2,3))
model_eval(mod) # training data
model_eval(mod, skeleton=TRUE)

}
