% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSVAR.R
\name{testVAR}
\alias{testVAR}
\title{Function to generate a VAR process}
\usage{
testVAR(
  n,
  p,
  struct = c("sparse", "low rank", "LS")[1],
  sp_density = 0.1,
  signal = NULL,
  rank = NULL,
  singular_vals,
  spectral_radius = 0.9,
  sigma = NULL,
  skip = 50,
  seed = 1
)
}
\arguments{
\item{n}{the length of time series}

\item{p}{the number of multivariate time series}

\item{struct}{a character string indicating the structure of the transition matrix, here are three options:
sparse, low rank and LS (low rank plus sparse)}

\item{sp_density}{a numeric value, indicating the sparsity density of sparse components, default is 0.1}

\item{signal}{a numeric value, indicating the magnitude of transition matrix}

\item{rank}{a positive integer, the rank for low rank component}

\item{singular_vals}{a numeric vector, indicating the singular values for the low rank component, the length of
singular value must equal to the rank}

\item{spectral_radius}{a numeric value, controlling the stability of the process, default is 0.9}

\item{sigma}{a numeric matrix, indicating the covariance matrix of noise term}

\item{skip}{a numeric value, indicating the number of skipped time points in the beginning of the process}

\item{seed}{an integer, indicating the seed for random seed.}
}
\value{
A list object, including
\describe{
    \item{series}{the generated time series}
    \item{noise}{the noise term}
    \item{model_param}{true transition matrix}
}
}
\description{
A function to generate synthetic time series process based on the given structure
}
\examples{
n <- 300; p <- 15
signal <- 0.75
rank <- 3
singular_vals <- c(1, 0.75, 0.5)
try <- testVAR(n, p, struct = "LS", signal = signal, rank = rank,
               singular_vals = singular_vals)
data <- as.matrix(try$series)
}
