% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{topModels}
\alias{topModels}
\title{Extract Top Models from \code{ULLGM_BMA} Estimation Results}
\usage{
topModels(x,
          variable_names = NULL,
          type           = "pandoc",
          digits         = 3,
          n              = 5)
}
\arguments{
\item{x}{The output object of \code{ULLGM_BMA}.}

\item{variable_names}{A character vector specifying the names of the columns of X.}

\item{type}{A character string indicating the format of the table. Options are \code{'pandoc'} (default), \code{'latex'}, or \code{'html'}.}

\item{digits}{Number of digits to round the table to. Defaults to 3.}

\item{n}{Number of top models to be returned. Defaults to 5.}
}
\value{
Returns a 'knitr::kable' object containing the table of top models.
}
\description{
\code{topModels} produces a table of the top n models from a \code{ULLGM_BMA} object, sorted by posterior model probabilities.
}
\examples{
# Load package
library(LatentBMA)

# Example: Estimate a PLN model under a BRIC prior with m = p/2 using simulated data
# Note: Use more samples for actual analysis
# Note: nsave = 250 and nburn = 250 are for demonstration purposes
X <- matrix(rnorm(100*20), 100, 20)
z <- 2 + X \%*\% c(0.5, -0.5, rep(0, 18)) + rnorm(100, 0, sqrt(0.25))
y <- rpois(100, exp(z))
results_pln <- ULLGM_BMA(X = X, y = y, model = "PLN", nsave = 250, nburn = 250)
# Top 5 models
topModels(results_pln)

}
\author{
Gregor Zens
}
