% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_setup.R
\docType{class}
\name{LeMans_param-class}
\alias{LeMans_param-class}
\title{An S4 class representing the inputs of the LeMans model}
\description{
An S4 class representing the inputs of the LeMans model
}
\details{
Sets the class of a LeMansParam object, which is then used to run the LeMans model.
}
\section{Slots}{

\describe{
\item{\code{nsc}}{A numeric value representing the number of length classes in the model.}

\item{\code{nfish}}{A numeric value representing the number of fish species in the model.}

\item{\code{phi_min}}{A numeric value representing the time step of the model.}

\item{\code{l_bound}}{A numeric vector of length \code{nsc} representing the lower bounds of the length classes.}

\item{\code{u_bound}}{A numeric vector of length \code{nsc} representing the upper bounds of the length classes.}

\item{\code{mid}}{A numeric vector of length \code{nfish} representing the mid-point of the length classes.}

\item{\code{species_names}}{A numeric or character vector of length \code{nfish} that denotes the names of the species in the model.}

\item{\code{Linf}}{A numeric vector of length \code{nfish} representing the mid-point of the length classes.}

\item{\code{W_a}}{A numeric vector representing the parameter \code{a} in the length-weight conversion.}

\item{\code{W_b}}{A numeric vector representing the parameter \code{b} in the length-weight conversion.}

\item{\code{k}}{k A numeric vector of length \code{nfish} representing the von Bertalanffy growth parameter \code{(1/yr)} for each species.}

\item{\code{Lmat}}{A numeric vector of length \code{nsc} representing the length at which 50\% of the individuals are mature.}

\item{\code{mature}}{A matrix with dimensions \code{nsc} and \code{nfish} with elements in the range 0-1 representing the proportion of mature individuals of each species in each length class.}

\item{\code{sc_Linf}}{A numeric vector of length \code{nsc} representing the length class at which each species reaches its asymptotic length.}

\item{\code{wgt}}{A matrix with dimensions \code{nsc} and \code{nfish} representing the weight of each species in each length class.}

\item{\code{phi}}{A matrix with dimensions \code{nsc} and \code{nfish} representing the proportion of individuals that leave each length class.}

\item{\code{ration}}{A matrix with dimensions \code{nsc} and \code{nfish} representing the amount of food required for fish of a given species and length class to grow according to the von Bertalanffy growth curve in a time step.}

\item{\code{other}}{A numeric value representing the amount of other food (g) available from prey that is not explicitly represented in the model.}

\item{\code{M1}}{A matrix of dimensions \code{nsc} and \code{nfish} representing the natural mortality of each species for each length class.}

\item{\code{suit_M2}}{A list object of length \code{nfish}. Each element in the list is an array of dimensions \code{nsc}, \code{nsc} and \code{nfish} containing a value between 0 and 1 representing prey preference and prey suitability for each species and length class.}

\item{\code{Qs}}{An array of dimensions \code{nsc}, \code{nfish} and \code{length(gear)} representing the catchability of each species by each of the fishing gears.}

\item{\code{stored_rec_funs}}{A list object of length \code{rec_fun} where each element includes the stock recruitment function for a given species. If an invalid recruitment function is selected, \code{NULL} is returned and a warning message is shown.}

\item{\code{eps}}{A numeric value specifying a numerical offset. The default value is \code{1e-5}.}

\item{\code{recruit_params}}{A list object of length \code{nfish} specifying the parameters for the recruitment function.}
}}

